/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.support;

import java.io.IOException;
import org.jpc.support.BlockDevice;
import org.jpc.support.SeekableIODevice;

public class FloppyBlockDevice
implements BlockDevice {
    public static final int TYPE_HD = 0;
    public static final int TYPE_CDROM = 1;
    public static final int TYPE_FLOPPY = 2;
    private SeekableIODevice data;

    public FloppyBlockDevice(SeekableIODevice seekableIODevice) {
        this.data = seekableIODevice;
    }

    public String getImageFileName() {
        return this.data.toString();
    }

    public void close() {
    }

    public int read(long l, byte[] byArray, int n) {
        try {
            this.data.seek((int)(l * 512L));
            if (this.data.read(byArray, 0, n * 512) != n * 512) {
                System.err.println("Did not read enough! ERROR?");
                return -1;
            }
            return 0;
        }
        catch (IOException iOException) {
            System.err.println("IO Error Reading From " + this.data.toString());
            iOException.printStackTrace();
            return -1;
        }
    }

    public int write(long l, byte[] byArray, int n) {
        try {
            this.data.seek((int)(l * 512L));
            this.data.write(byArray, 0, n * 512);
        }
        catch (IOException iOException) {
            System.err.println("IO Error Writing To " + this.data.toString());
            iOException.printStackTrace();
            return -1;
        }
        return 0;
    }

    public boolean inserted() {
        return this.data != null;
    }

    public boolean locked() {
        return false;
    }

    public void setLock(boolean bl) {
    }

    public long getTotalSectors() {
        return this.data.length();
    }

    public int cylinders() {
        return -1;
    }

    public int heads() {
        return -1;
    }

    public int sectors() {
        return -1;
    }

    public int type() {
        return 2;
    }

    public boolean readOnly() {
        return this.data.readOnly();
    }

    public String toString() {
        return "Floppy: " + this.data.toString();
    }

    public void configure(String string) throws Exception {
        this.data.configure(string);
    }
}

