/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci.peripheral;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.memory.Memory;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.pci.AbstractPCIDevice;
import org.jpc.emulator.pci.IORegion;
import org.jpc.emulator.pci.PCIBus;
import org.jpc.emulator.pci.PCIDevice;
import org.jpc.emulator.pci.PCIISABridge;
import org.jpc.emulator.pci.peripheral.BMDMAIORegion;
import org.jpc.emulator.pci.peripheral.IDEChannel;
import org.jpc.support.BlockDevice;
import org.jpc.support.DriveSet;

public class PIIX3IDEInterface
extends AbstractPCIDevice
implements HardwareComponent {
    private InterruptController irqDevice;
    private IDEChannel[] channels;
    private BMDMAIORegion[] bmdmaRegions;
    private BlockDevice[] drives;
    private boolean ioportRegistered = false;
    private boolean pciRegistered = false;
    private boolean dmaRegistered = false;
    private boolean devfnSet = false;

    public PIIX3IDEInterface() {
        this.assignDevFN(-1);
        this.putConfigByte(0, (byte)-122);
        this.putConfigByte(1, (byte)-128);
        this.putConfigByte(2, (byte)16);
        this.putConfigByte(3, (byte)112);
        this.putConfigByte(9, (byte)-128);
        this.putConfigByte(10, (byte)1);
        this.putConfigByte(11, (byte)1);
        this.putConfigByte(14, (byte)0);
        this.channels = new IDEChannel[2];
        this.bmdmaRegions = new BMDMAIORegion[2];
        this.bmdmaRegions[1] = new BMDMAIORegion(null);
        this.bmdmaRegions[0] = new BMDMAIORegion(this.bmdmaRegions[1]);
    }

    public boolean autoAssignDevFN() {
        return false;
    }

    public void deassignDevFN() {
        System.err.println("Conflict with IDE Interface over PCI Device FN");
    }

    public IORegion[] getIORegions() {
        return new IORegion[]{this.bmdmaRegions[0]};
    }

    public IORegion getIORegion(int n) {
        if (n == 4) {
            return this.bmdmaRegions[0];
        }
        return null;
    }

    public boolean initialised() {
        return this.ioportRegistered && this.pciRegistered && this.dmaRegistered && this.irqDevice != null && this.drives != null;
    }

    public void reset() {
        this.devfnSet = false;
        this.ioportRegistered = false;
        this.pciRegistered = false;
        this.assignDevFN(-1);
        this.putConfigByte(0, (byte)-122);
        this.putConfigByte(1, (byte)-128);
        this.putConfigByte(2, (byte)16);
        this.putConfigByte(3, (byte)112);
        this.putConfigByte(9, (byte)-128);
        this.putConfigByte(10, (byte)1);
        this.putConfigByte(11, (byte)1);
        this.putConfigByte(14, (byte)0);
        this.channels = new IDEChannel[2];
        this.dmaRegistered = false;
        this.bmdmaRegions = new BMDMAIORegion[2];
        this.bmdmaRegions[1] = new BMDMAIORegion(null);
        this.bmdmaRegions[0] = new BMDMAIORegion(this.bmdmaRegions[1]);
        this.irqDevice = null;
        this.drives = null;
        super.reset();
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqDevice = (InterruptController)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised() && this.irqDevice != null && this.drives != null) {
            this.channels[0] = new IDEChannel(14, this.irqDevice, 496, 1014, new BlockDevice[]{this.drives[0], this.drives[1]}, this.bmdmaRegions[0]);
            this.channels[1] = new IDEChannel(15, this.irqDevice, 368, 886, new BlockDevice[]{this.drives[2], this.drives[3]}, this.bmdmaRegions[1]);
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this.channels[0]);
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this.channels[1]);
            this.ioportRegistered = true;
        }
        if (hardwareComponent instanceof PCIBus && hardwareComponent.initialised() && !this.pciRegistered && this.devfnSet) {
            this.pciRegistered = ((PCIBus)hardwareComponent).registerDevice(this);
        }
        if (hardwareComponent instanceof PCIISABridge && hardwareComponent.initialised()) {
            this.assignDevFN(((PCIDevice)((Object)hardwareComponent)).getCurrentDevFN() + 1);
            this.devfnSet = true;
        }
        if (hardwareComponent instanceof DriveSet && hardwareComponent.initialised()) {
            this.drives = new BlockDevice[4];
            this.drives[0] = ((DriveSet)hardwareComponent).getHardDrive(0);
            this.drives[1] = ((DriveSet)hardwareComponent).getHardDrive(1);
            this.drives[2] = ((DriveSet)hardwareComponent).getHardDrive(2);
            this.drives[3] = ((DriveSet)hardwareComponent).getHardDrive(3);
        }
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.dmaRegistered = true;
            this.bmdmaRegions[0].setAddressSpace((Memory)((Object)hardwareComponent));
            this.bmdmaRegions[1].setAddressSpace((Memory)((Object)hardwareComponent));
        }
    }

    public String toString() {
        return "Intel PIIX3 IDE Interface";
    }
}

