/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.pci.AbstractPCIDevice;
import org.jpc.emulator.pci.IORegion;
import org.jpc.emulator.pci.PCIBus;

public class PCIHostBridge
extends AbstractPCIDevice
implements IOPortCapable,
HardwareComponent {
    private PCIBus attachedBus;
    private int configRegister;
    private boolean ioportRegistered = false;
    private boolean pciRegistered;

    public PCIHostBridge() {
        this.assignDevFN(0);
        this.putConfigByte(0, (byte)-122);
        this.putConfigByte(1, (byte)-128);
        this.putConfigByte(2, (byte)55);
        this.putConfigByte(3, (byte)18);
        this.putConfigByte(8, (byte)2);
        this.putConfigByte(10, (byte)0);
        this.putConfigByte(11, (byte)6);
        this.putConfigByte(14, (byte)0);
    }

    public boolean autoAssignDevFN() {
        return false;
    }

    public void deassignDevFN() {
        System.err.println("Conflict with Host Bridge over PCI Device FN");
    }

    public IORegion[] getIORegions() {
        return null;
    }

    public IORegion getIORegion(int n) {
        return null;
    }

    public int[] ioPortsRequested() {
        int[] nArray = new int[]{3320, 3321, 3322, 3323, 3324, 3325, 3326, 3327};
        return nArray;
    }

    public void ioPortWriteByte(int n, int n2) {
        switch (n) {
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: {
                if ((this.configRegister & Integer.MIN_VALUE) == 0) break;
                this.attachedBus.writePCIDataByte(this.configRegister | n & 3, (byte)n2);
                break;
            }
        }
    }

    public void ioPortWriteWord(int n, int n2) {
        switch (n) {
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: {
                if ((this.configRegister & Integer.MIN_VALUE) == 0) break;
                this.attachedBus.writePCIDataWord(this.configRegister | n & 3, (short)n2);
                break;
            }
        }
    }

    public void ioPortWriteLong(int n, int n2) {
        switch (n) {
            case 3320: 
            case 3321: 
            case 3322: 
            case 3323: {
                this.configRegister = n2;
                break;
            }
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: {
                if ((this.configRegister & Integer.MIN_VALUE) == 0) break;
                this.attachedBus.writePCIDataLong(this.configRegister | n & 3, n2);
                break;
            }
        }
    }

    public int ioPortReadByte(int n) {
        switch (n) {
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: {
                if ((this.configRegister & Integer.MIN_VALUE) == 0) {
                    return 255;
                }
                return 0xFF & this.attachedBus.readPCIDataByte(this.configRegister | n & 3);
            }
        }
        return 255;
    }

    public int ioPortReadWord(int n) {
        switch (n) {
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: {
                if ((this.configRegister & Integer.MIN_VALUE) == 0) {
                    return 65535;
                }
                return 0xFFFF & this.attachedBus.readPCIDataWord(this.configRegister | n & 3);
            }
        }
        return 65535;
    }

    public int ioPortReadLong(int n) {
        switch (n) {
            case 3320: 
            case 3321: 
            case 3322: 
            case 3323: {
                return this.configRegister;
            }
            case 3324: 
            case 3325: 
            case 3326: 
            case 3327: {
                if ((this.configRegister & Integer.MIN_VALUE) == 0) {
                    return -1;
                }
                return this.attachedBus.readPCIDataLong(this.configRegister | n & 3);
            }
        }
        return -1;
    }

    public boolean initialised() {
        return this.ioportRegistered && this.pciRegistered;
    }

    public void reset() {
        this.attachedBus = null;
        this.pciRegistered = false;
        this.ioportRegistered = false;
        this.assignDevFN(0);
        this.putConfigByte(0, (byte)-122);
        this.putConfigByte(1, (byte)-128);
        this.putConfigByte(2, (byte)55);
        this.putConfigByte(3, (byte)18);
        this.putConfigByte(8, (byte)2);
        this.putConfigByte(10, (byte)0);
        this.putConfigByte(11, (byte)6);
        this.putConfigByte(14, (byte)0);
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PCIBus && hardwareComponent.initialised() && !this.pciRegistered) {
            this.attachedBus = (PCIBus)hardwareComponent;
            this.pciRegistered = this.attachedBus.registerDevice(this);
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    public String toString() {
        return "Intel i440FX PCI-Host Bridge";
    }
}

