/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.motherboard.IOPortCapable;

public class IOPortHandler
implements IOPortCapable,
HardwareComponent {
    private static final int MAX_IOPORTS = 65536;
    IOPortCapable[] ioPortDevice;
    static IOPortCapable defaultDevice;

    public IOPortHandler() {
        defaultDevice = new UnconnectedIOPort();
        this.ioPortDevice = new IOPortCapable[65536];
        for (int i = 0; i < this.ioPortDevice.length; ++i) {
            this.ioPortDevice[i] = defaultDevice;
        }
    }

    public int ioPortReadByte(int n) {
        return this.ioPortDevice[n].ioPortReadByte(n);
    }

    public int ioPortReadWord(int n) {
        return this.ioPortDevice[n].ioPortReadWord(n);
    }

    public int ioPortReadLong(int n) {
        return this.ioPortDevice[n].ioPortReadLong(n);
    }

    public void ioPortWriteByte(int n, int n2) {
        this.ioPortDevice[n].ioPortWriteByte(n, n2);
    }

    public void ioPortWriteWord(int n, int n2) {
        this.ioPortDevice[n].ioPortWriteWord(n, n2);
    }

    public void ioPortWriteLong(int n, int n2) {
        this.ioPortDevice[n].ioPortWriteLong(n, n2);
    }

    public int[] ioPortsRequested() {
        return null;
    }

    public void registerIOPortCapable(IOPortCapable iOPortCapable) {
        int[] nArray = iOPortCapable.ioPortsRequested();
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (this.ioPortDevice[n] != defaultDevice && this.ioPortDevice[n] != iOPortCapable) continue;
            this.ioPortDevice[n] = iOPortCapable;
        }
    }

    public void deregisterIOPortCapable(IOPortCapable iOPortCapable) {
        int[] nArray = iOPortCapable.ioPortsRequested();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            this.ioPortDevice[n] = defaultDevice;
        }
    }

    public String map() {
        String string = new String();
        string = string + "IO Port Handler:\n";
        string = string + "Registered Ports:\n";
        for (int i = 0; i < 65536; ++i) {
            if (this.ioPortDevice[i] == defaultDevice) continue;
            string = string + "Port: 0x" + Integer.toHexString(0xFFFF & i) + " - ";
            string = string + this.ioPortDevice[i].getClass().getName() + "\n";
        }
        return string;
    }

    public void reset() {
        this.ioPortDevice = new IOPortCapable[65536];
        for (int i = 0; i < this.ioPortDevice.length; ++i) {
            this.ioPortDevice[i] = defaultDevice;
        }
    }

    public boolean initialised() {
        return true;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
    }

    public String toString() {
        return "IOPort Bus";
    }

    static class UnconnectedIOPort
    implements IOPortCapable {
        UnconnectedIOPort() {
        }

        public int ioPortReadByte(int n) {
            return 255;
        }

        public int ioPortReadWord(int n) {
            return 65535;
        }

        public int ioPortReadLong(int n) {
            return -1;
        }

        public void ioPortWriteByte(int n, int n2) {
        }

        public void ioPortWriteWord(int n, int n2) {
        }

        public void ioPortWriteLong(int n, int n2) {
        }

        public int[] ioPortsRequested() {
            return null;
        }
    }
}

