/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock.basic;

import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;
import org.jpc.emulator.memory.codeblock.basic.FirstStageCodeBlock;
import org.jpc.emulator.memory.codeblock.basic.RealModeDecoder;
import org.jpc.emulator.processor.Processor;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.emulator.processor.Segment;

public class RealModeFirstStageCodeBlock
extends FirstStageCodeBlock
implements RealModeCodeBlock {
    private static final ProcessorException exceptionBR = new ProcessorException(5, true);
    private static final ProcessorException exceptionSS = new ProcessorException(12, true);
    private static final ProcessorException exceptionGP = new ProcessorException(13, true);
    private boolean eipUpdated;

    public RealModeFirstStageCodeBlock() {
    }

    public RealModeFirstStageCodeBlock(int[] nArray, int[] nArray2) {
        super(nArray, nArray2);
    }

    public String toString() {
        return "RealModeFirstStageCodeBlock";
    }

    public synchronized int execute(Processor processor) {
        this.cpu = processor;
        this.fpu = processor.fpu;
        int n = 0;
        this.executeCount = this.getX86Count();
        this.eipUpdated = false;
        try {
            this.microcodesPosition = 0;
            while (this.microcodesPosition < this.microcodes.length) {
                this.dispatchOpcode();
                n = this.microcodesPosition;
            }
        }
        catch (ProcessorException processorException) {
            if (processorException.getVector() == -1) {
                throw new IllegalStateException("Failed To Execute Block: " + processorException);
            }
            if (this.eipUpdated) {
                if (processorException.pointsToSelf()) {
                    processor.eip -= this.cumulativeX86Length[n];
                }
                if (n >= 2) {
                    processor.eip += this.cumulativeX86Length[n - 2];
                }
            } else {
                if (processorException.pointsToSelf()) {
                    this.microcodesPosition = n;
                }
                if (this.microcodesPosition > 0) {
                    this.eipUpdate();
                }
            }
            if (processorException.getVector() != 14) {
                System.out.println();
                System.out.println("EIP: 0x" + Integer.toHexString(processor.eip));
                processorException.printStackTrace();
            }
            processor.handleRealModeException(processorException.getVector());
        }
        return Math.max(this.executeCount, 0);
    }

    private final void dispatchOpcode() throws ProcessorException {
        int n = this.getMicrocode();
        switch (n) {
            case 23: {
                this.aaa();
                return;
            }
            case 144: {
                this.aad();
                return;
            }
            case 143: {
                this.aam();
                return;
            }
            case 27: {
                this.aas();
                return;
            }
            case 6: {
                this.adc_o8();
                return;
            }
            case 8: {
                this.adc_o16();
                return;
            }
            case 7: {
                this.adc_o32();
                return;
            }
            case 0: {
                this.add_o8();
                return;
            }
            case 2: {
                this.add_o16();
                return;
            }
            case 1: {
                this.add_o32();
                return;
            }
            case 12: {
                this.and_o8();
                return;
            }
            case 14: {
                this.and_o16();
                return;
            }
            case 13: {
                this.and_o32();
                return;
            }
            case 48: {
                this.bound_o16_a16();
                return;
            }
            case 482: {
                this.bsf_o16();
                return;
            }
            case 483: {
                this.bsf_o32();
                return;
            }
            case 484: {
                this.bsr_o16();
                return;
            }
            case 485: {
                this.bsr_o32();
                return;
            }
            case 496: {
                this.bswap();
                return;
            }
            case 469: {
                this.bt_o16();
                return;
            }
            case 470: {
                this.bt_o32();
                return;
            }
            case 477: {
                this.bt_o16_o8();
                return;
            }
            case 478: {
                this.bt_o32_o8();
                return;
            }
            case 471: {
                this.btc_o16();
                return;
            }
            case 472: {
                this.btc_o32();
                return;
            }
            case 480: {
                this.btc_o32_o8();
                return;
            }
            case 465: {
                this.btr_o16();
                return;
            }
            case 466: {
                this.btr_o32();
                return;
            }
            case 474: {
                this.btr_o32_o8();
                return;
            }
            case 467: {
                this.bts_o16();
                return;
            }
            case 468: {
                this.bts_o32();
                return;
            }
            case 476: {
                this.bts_o32_o8();
                return;
            }
            case 200: {
                this.call_o16_a16();
                return;
            }
            case 201: {
                this.call_o32_a16();
                return;
            }
            case 88: {
                this.callf_o16_a16();
                return;
            }
            case 317: {
                this.calln_o16_a16();
                return;
            }
            case 85: {
                this.cbw();
                return;
            }
            case 86: {
                this.cdq();
                return;
            }
            case 179: {
                this.clc();
                return;
            }
            case 183: {
                this.cld();
                return;
            }
            case 181: {
                this.cli();
                return;
            }
            case 178: {
                this.cmc();
                return;
            }
            case 24: {
                this.cmp_o8();
                return;
            }
            case 26: {
                this.cmp_o16();
                return;
            }
            case 25: {
                this.cmp_o32();
                return;
            }
            case 191: {
                this.cmps_o8_a16();
                return;
            }
            case 192: {
                this.cmps_o16_a16();
                return;
            }
            case 193: {
                this.cmps_o32_a16();
                return;
            }
            case 359: {
                this.cmps_o8_a32();
                return;
            }
            case 360: {
                this.cmps_o16_a32();
                return;
            }
            case 361: {
                this.cmps_o32_a32();
                return;
            }
            case 492: {
                this.cmpxchg_o8();
                return;
            }
            case 493: {
                this.cmpxchg_o16();
                return;
            }
            case 494: {
                this.cmpxchg_o32();
                return;
            }
            case 495: {
                this.cmpxchg8b();
                return;
            }
            case 448: {
                this.cpuid();
                return;
            }
            case 87: {
                this.cwd();
                return;
            }
            case 84: {
                this.cwde();
                return;
            }
            case 15: {
                this.daa();
                return;
            }
            case 19: {
                this.das();
                return;
            }
            case 231: {
                this.dec_o8();
                return;
            }
            case 31: {
                this.dec_o16();
                return;
            }
            case 30: {
                this.dec_o32();
                return;
            }
            case 243: {
                this.div_o8();
                return;
            }
            case 233: {
                this.div_o16();
                return;
            }
            case 238: {
                this.div_o32();
                return;
            }
            case 111: {
                this.enter_o16_a16();
                return;
            }
            case 602: {
                this.f2xm1();
                return;
            }
            case 592: {
                break;
            }
            case 557: {
                this.fadd();
                return;
            }
            case 497: {
                this.fadd_sr();
                return;
            }
            case 526: {
                this.fadd_dr();
                return;
            }
            case 582: {
                this.faddp();
                return;
            }
            case 553: {
                break;
            }
            case 555: {
                break;
            }
            case 591: {
                this.fchs();
                return;
            }
            case 619: {
                this.fclex();
                return;
            }
            case 567: {
                break;
            }
            case 571: {
                break;
            }
            case 569: {
                break;
            }
            case 573: {
                break;
            }
            case 568: {
                break;
            }
            case 572: {
                break;
            }
            case 570: {
                break;
            }
            case 574: {
                break;
            }
            case 559: {
                this.fcom();
                return;
            }
            case 499: {
                this.fcom_sr();
                return;
            }
            case 528: {
                this.fcom_dr();
                return;
            }
            case 576: {
                break;
            }
            case 589: {
                break;
            }
            case 560: {
                this.fcomp();
                return;
            }
            case 500: {
                this.fcomp_sr();
                return;
            }
            case 529: {
                this.fcomp_dr();
                return;
            }
            case 621: {
                this.fcompp();
                return;
            }
            case 617: {
                break;
            }
            case 608: {
                break;
            }
            case 563: {
                this.fdiv();
                return;
            }
            case 503: {
                this.fdiv_sr();
                return;
            }
            case 532: {
                this.fdiv_dr();
                return;
            }
            case 587: {
                this.fdivp();
                return;
            }
            case 564: {
                this.fdivr();
                return;
            }
            case 504: {
                this.fdivr_sr();
                return;
            }
            case 533: {
                this.fdivr_dr();
                return;
            }
            case 586: {
                this.fdivrp();
                return;
            }
            case 577: {
                break;
            }
            case 541: {
                break;
            }
            case 512: {
                break;
            }
            case 543: {
                break;
            }
            case 514: {
                break;
            }
            case 544: {
                break;
            }
            case 515: {
                break;
            }
            case 547: {
                break;
            }
            case 518: {
                break;
            }
            case 548: {
                this.fidivr_wi();
                return;
            }
            case 519: {
                this.fidivr_di();
                return;
            }
            case 549: {
                this.fild_wi();
                return;
            }
            case 520: {
                this.fild_di();
                return;
            }
            case 554: {
                this.fild_qi();
                return;
            }
            case 542: {
                break;
            }
            case 513: {
                break;
            }
            case 609: {
                break;
            }
            case 551: {
                this.fist_wi();
                return;
            }
            case 522: {
                this.fist_di();
                return;
            }
            case 552: {
                this.fistp_wi();
                return;
            }
            case 523: {
                this.fistp_di();
                return;
            }
            case 556: {
                this.fistp_qi();
                return;
            }
            case 550: {
                break;
            }
            case 521: {
                break;
            }
            case 535: {
                break;
            }
            case 545: {
                break;
            }
            case 516: {
                break;
            }
            case 546: {
                break;
            }
            case 517: {
                break;
            }
            case 565: {
                this.fld();
                return;
            }
            case 505: {
                this.fld_sr();
                return;
            }
            case 534: {
                this.fld_dr();
                return;
            }
            case 524: {
                break;
            }
            case 595: {
                this.fld1();
                return;
            }
            case 597: {
                break;
            }
            case 596: {
                break;
            }
            case 599: {
                break;
            }
            case 600: {
                break;
            }
            case 598: {
                break;
            }
            case 601: {
                this.fldz();
                return;
            }
            case 509: {
                this.fldcw();
                return;
            }
            case 558: {
                this.fmul();
                return;
            }
            case 498: {
                this.fmul_sr();
                return;
            }
            case 527: {
                this.fmul_dr();
                return;
            }
            case 583: {
                this.fmulp();
                return;
            }
            case 620: {
                this.fninit();
                return;
            }
            case 590: {
                break;
            }
            case 605: {
                break;
            }
            case 610: {
                this.fprem();
                return;
            }
            case 607: {
                this.fprem1();
                return;
            }
            case 604: {
                break;
            }
            case 614: {
                this.frndint();
                return;
            }
            case 615: {
                this.fscale();
                return;
            }
            case 616: {
                break;
            }
            case 613: {
                this.fsincos();
                return;
            }
            case 612: {
                this.fsqrt();
                return;
            }
            case 578: {
                break;
            }
            case 506: {
                break;
            }
            case 536: {
                this.fst_dr();
                return;
            }
            case 579: {
                this.fstp();
                return;
            }
            case 507: {
                this.fstp_sr();
                return;
            }
            case 537: {
                this.fstp_dr();
                return;
            }
            case 525: {
                break;
            }
            case 511: {
                this.fstcw();
                return;
            }
            case 540: {
                this.fstsw();
                return;
            }
            case 561: {
                this.fsub();
                return;
            }
            case 501: {
                this.fsub_sr();
                return;
            }
            case 530: {
                this.fsub_dr();
                return;
            }
            case 585: {
                this.fsubp();
                return;
            }
            case 562: {
                this.fsubr();
                return;
            }
            case 502: {
                this.fsubr_sr();
                return;
            }
            case 531: {
                this.fsubr_dr();
                return;
            }
            case 584: {
                this.fsubrp();
                return;
            }
            case 593: {
                this.ftst();
                return;
            }
            case 580: {
                this.fucom();
                return;
            }
            case 575: {
                break;
            }
            case 588: {
                break;
            }
            case 581: {
                this.fucomp();
                return;
            }
            case 618: {
                this.fucompp();
                return;
            }
            case 594: {
                break;
            }
            case 566: {
                this.fxch();
                return;
            }
            case 606: {
                break;
            }
            case 603: {
                this.fyl2x();
                return;
            }
            case 611: {
                this.fyl2xp1();
                return;
            }
            case 508: {
                break;
            }
            case 510: {
                this.fnstenv_14();
                return;
            }
            case 634: {
                break;
            }
            case 635: {
                break;
            }
            case 177: {
                this.hlt();
                return;
            }
            case 261: {
                this.idiv_o8();
                return;
            }
            case 232: {
                this.idiv_o16();
                return;
            }
            case 237: {
                this.idiv_o32();
                return;
            }
            case 53: {
                this.imul_o16();
                return;
            }
            case 52: {
                this.imul_o32();
                return;
            }
            case 376: {
                this.imul_rega_o8();
                return;
            }
            case 377: {
                this.imul_rega_o16();
                return;
            }
            case 378: {
                this.imul_rega_o32();
                return;
            }
            case 160: {
                this.in_o8_o8();
                return;
            }
            case 162: {
                this.in_o16_o8();
                return;
            }
            case 161: {
                this.in_o32_o8();
                return;
            }
            case 163: {
                this.in_o8_o16();
                return;
            }
            case 165: {
                this.in_o16_o16();
                return;
            }
            case 164: {
                this.in_o32_o16();
                return;
            }
            case 230: {
                this.inc_o8();
                return;
            }
            case 29: {
                this.inc_o16();
                return;
            }
            case 28: {
                this.inc_o32();
                return;
            }
            case 185: {
                this.ins_o8_a16();
                return;
            }
            case 131: {
                this.int_o16_a16();
                return;
            }
            case 127: {
                this.int3_o16_a16();
                return;
            }
            case 135: {
                this.into_o16_a16();
                return;
            }
            case 139: {
                this.iret_o16_a16();
                return;
            }
            case 207: {
                this.jmp_o16_far();
                return;
            }
            case 206: {
                this.jmp_o32_far();
                return;
            }
            case 205: {
                this.jmp_o16_near_relative();
                return;
            }
            case 375: {
                this.jmp_o16_near_absolute();
                return;
            }
            case 172: {
                this.jmp_o8_short();
                return;
            }
            case 158: {
                this.jcxz_a16();
                return;
            }
            case 159: {
                this.jcxz_a32();
                return;
            }
            case 56: {
                this.jb_o8();
                return;
            }
            case 323: {
                this.jb_o16();
                return;
            }
            case 339: {
                this.jb_o32();
                return;
            }
            case 57: {
                this.jnb_o8();
                return;
            }
            case 324: {
                this.jnb_o16();
                return;
            }
            case 60: {
                this.jbe_o8();
                return;
            }
            case 327: {
                this.jbe_o16();
                return;
            }
            case 61: {
                this.jnbe_o8();
                return;
            }
            case 328: {
                this.jnbe_o16();
                return;
            }
            case 66: {
                this.jl_o8();
                return;
            }
            case 333: {
                this.jl_o16();
                return;
            }
            case 67: {
                this.jnl_o8();
                return;
            }
            case 334: {
                this.jnl_o16();
                return;
            }
            case 68: {
                this.jle_o8();
                return;
            }
            case 335: {
                this.jle_o16();
                return;
            }
            case 69: {
                this.jnle_o8();
                return;
            }
            case 336: {
                this.jnle_o16();
                return;
            }
            case 54: {
                this.jo_o8();
                return;
            }
            case 321: {
                this.jo_o16();
                return;
            }
            case 55: {
                this.jno_o8();
                return;
            }
            case 322: {
                this.jno_o16();
                return;
            }
            case 64: {
                this.jp_o8();
                return;
            }
            case 331: {
                this.jp_o16();
                return;
            }
            case 65: {
                this.jnp_o8();
                return;
            }
            case 332: {
                this.jnp_o16();
                return;
            }
            case 62: {
                this.js_o8();
                return;
            }
            case 329: {
                this.js_o16();
                return;
            }
            case 63: {
                this.jns_o8();
                return;
            }
            case 330: {
                this.jns_o16();
                return;
            }
            case 58: {
                this.jz_o8();
                return;
            }
            case 325: {
                this.jz_o16();
                return;
            }
            case 59: {
                this.jnz_o8();
                return;
            }
            case 326: {
                this.jnz_o16();
                return;
            }
            case 102: {
                this.lahf();
                return;
            }
            case 101: {
                this.sahf();
                return;
            }
            case 77: {
                this.lea_o16_a16();
                return;
            }
            case 80: {
                this.lea_o32_a32();
                return;
            }
            case 115: {
                this.leave_o16_a16();
                return;
            }
            case 247: {
                this.les_o16_a16();
                return;
            }
            case 251: {
                this.lds_o16_a16();
                return;
            }
            case 252: {
                this.lds_o32_a16();
                return;
            }
            case 622: {
                this.lfs_o16_a16();
                return;
            }
            case 626: {
                this.lgs_o16_a16();
                return;
            }
            case 381: {
                this.lgdt_o16();
                return;
            }
            case 382: {
                this.lgdt_o32();
                return;
            }
            case 385: {
                this.lidt_o16();
                return;
            }
            case 386: {
                this.lidt_o32();
                return;
            }
            case 388: {
                this.lmsw();
                return;
            }
            case 258: {
                this.lods_o8_a16();
                return;
            }
            case 259: {
                this.lods_o16_a16();
                return;
            }
            case 260: {
                this.lods_o32_a16();
                return;
            }
            case 371: {
                this.lods_o8_a32();
                return;
            }
            case 372: {
                this.lods_o16_a32();
                return;
            }
            case 373: {
                this.lods_o32_a32();
                return;
            }
            case 154: {
                this.loop_o16_a16();
                return;
            }
            case 155: {
                this.loop_o32_a16();
                return;
            }
            case 150: {
                this.loopz_o16_a16();
                return;
            }
            case 146: {
                this.loopnz_o16_a16();
                return;
            }
            case 396: {
                this.lss_o16_a16();
                return;
            }
            case 397: {
                this.lss_o32_a16();
                return;
            }
            case 74: {
                this.mov_o8();
                return;
            }
            case 76: {
                this.mov_o16();
                return;
            }
            case 75: {
                this.mov_o32();
                return;
            }
            case 390: {
                this.mov_to_cr_o32();
                return;
            }
            case 188: {
                this.movs_o8_a16();
                return;
            }
            case 189: {
                this.movs_o16_a16();
                return;
            }
            case 356: {
                this.movs_o8_a32();
                return;
            }
            case 357: {
                this.movs_o16_a32();
                return;
            }
            case 358: {
                this.movs_o32_a32();
                return;
            }
            case 190: {
                this.movs_o32_a16();
                return;
            }
            case 457: {
                this.movsx_o16_o8();
                return;
            }
            case 458: {
                this.movsx_o32_o8();
                return;
            }
            case 459: {
                this.movsx_o16_o16();
                return;
            }
            case 460: {
                this.movsx_o32_o16();
                return;
            }
            case 392: {
                this.movzx_o16_o8();
                return;
            }
            case 393: {
                this.movzx_o32_o8();
                return;
            }
            case 394: {
                this.movzx_o16_o16();
                return;
            }
            case 395: {
                this.movzx_o32_o16();
                return;
            }
            case 244: {
                this.mul_o8();
                return;
            }
            case 234: {
                this.mul_o16();
                return;
            }
            case 239: {
                this.mul_o32();
                return;
            }
            case 245: {
                this.neg_o8();
                return;
            }
            case 235: {
                this.neg_o16();
                return;
            }
            case 240: {
                this.neg_o32();
                return;
            }
            case 81: {
                return;
            }
            case 246: {
                this.not_o8();
                return;
            }
            case 236: {
                this.not_o16();
                return;
            }
            case 241: {
                this.not_o32();
                return;
            }
            case 3: {
                this.or_o8();
                return;
            }
            case 5: {
                this.or_o16();
                return;
            }
            case 4: {
                this.or_o32();
                return;
            }
            case 166: {
                this.out_o8_o8();
                return;
            }
            case 168: {
                this.out_o8_o16();
                return;
            }
            case 167: {
                this.out_o8_o32();
                return;
            }
            case 169: {
                this.out_o16_o8();
                return;
            }
            case 171: {
                this.out_o16_o16();
                return;
            }
            case 170: {
                this.out_o16_o32();
                return;
            }
            case 255: {
                this.outs_o8_a16();
                return;
            }
            case 256: {
                this.outs_o16_a16();
                return;
            }
            case 257: {
                this.outs_o32_a16();
                return;
            }
            case 36: {
                this.pop_o16_a16();
                return;
            }
            case 37: {
                this.pop_o32_a16();
                return;
            }
            case 44: {
                this.popa_o16_a16();
                return;
            }
            case 45: {
                this.popa_o32_a16();
                return;
            }
            case 97: {
                this.popf_o16_a16();
                return;
            }
            case 98: {
                this.popf_o32_a16();
                return;
            }
            case 32: {
                this.push_o16_a16();
                return;
            }
            case 33: {
                this.push_o32_a16();
                return;
            }
            case 40: {
                this.pusha_o16_a16();
                return;
            }
            case 41: {
                this.pusha_o32_a16();
                return;
            }
            case 93: {
                this.pushf_o16_a16();
                return;
            }
            case 94: {
                this.pushf_o32_a16();
                return;
            }
            case 296: {
                this.repe_cmps_o8_a32();
                return;
            }
            case 297: {
                this.repe_cmps_o16_a32();
                return;
            }
            case 298: {
                this.repe_cmps_o32_a32();
                return;
            }
            case 269: {
                this.repe_cmps_o8_a16();
                return;
            }
            case 270: {
                this.repe_cmps_o16_a16();
                return;
            }
            case 263: {
                this.rep_ins_o8_a16();
                return;
            }
            case 264: {
                this.rep_ins_o16_a16();
                return;
            }
            case 265: {
                this.rep_ins_o32_a16();
                return;
            }
            case 314: {
                this.rep_lods_o8_a32();
                return;
            }
            case 315: {
                this.rep_lods_o16_a32();
                return;
            }
            case 316: {
                this.rep_lods_o32_a32();
                return;
            }
            case 266: {
                this.rep_movs_o8_a16();
                return;
            }
            case 267: {
                this.rep_movs_o16_a16();
                return;
            }
            case 268: {
                this.rep_movs_o32_a16();
                return;
            }
            case 293: {
                this.rep_movs_o8_a32();
                return;
            }
            case 294: {
                this.rep_movs_o16_a32();
                return;
            }
            case 295: {
                this.rep_movs_o32_a32();
                return;
            }
            case 284: {
                this.rep_outs_o8_a16();
                return;
            }
            case 285: {
                this.rep_outs_o16_a16();
                return;
            }
            case 286: {
                this.rep_outs_o32_a16();
                return;
            }
            case 278: {
                this.repe_scas_o8_a16();
                return;
            }
            case 279: {
                this.repe_scas_o16_a16();
                return;
            }
            case 280: {
                this.repe_scas_o32_a16();
                return;
            }
            case 305: {
                this.repe_scas_o8_a32();
                return;
            }
            case 306: {
                this.repe_scas_o16_a32();
                return;
            }
            case 307: {
                this.repe_scas_o32_a32();
                return;
            }
            case 281: {
                this.repne_scas_o8_a16();
                return;
            }
            case 282: {
                this.repne_scas_o16_a16();
                return;
            }
            case 283: {
                this.repne_scas_o32_a16();
                return;
            }
            case 308: {
                this.repne_scas_o8_a32();
                return;
            }
            case 309: {
                this.repne_scas_o16_a32();
                return;
            }
            case 310: {
                this.repne_scas_o32_a32();
                return;
            }
            case 275: {
                this.rep_stos_o8_a16();
                return;
            }
            case 276: {
                this.rep_stos_o16_a16();
                return;
            }
            case 277: {
                this.rep_stos_o32_a16();
                return;
            }
            case 302: {
                this.rep_stos_o8_a32();
                return;
            }
            case 303: {
                this.rep_stos_o16_a32();
                return;
            }
            case 304: {
                this.rep_stos_o32_a32();
                return;
            }
            case 107: {
                this.ret_o16_a16();
                return;
            }
            case 108: {
                this.ret_o32_a16();
                return;
            }
            case 103: {
                this.ret_iw_o16_a16();
                return;
            }
            case 123: {
                this.retf_o16_a16();
                return;
            }
            case 119: {
                this.retf_iw_o16_a16();
                return;
            }
            case 210: {
                this.rcl_o8();
                return;
            }
            case 217: {
                this.rcl_o16();
                return;
            }
            case 224: {
                this.rcl_o32();
                return;
            }
            case 211: {
                this.rcr_o8();
                return;
            }
            case 218: {
                this.rcr_o16();
                return;
            }
            case 225: {
                this.rcr_o32();
                return;
            }
            case 208: {
                this.rol_o8();
                return;
            }
            case 215: {
                this.rol_o16();
                return;
            }
            case 222: {
                this.rol_o32();
                return;
            }
            case 209: {
                this.ror_o8();
                return;
            }
            case 216: {
                this.ror_o16();
                return;
            }
            case 223: {
                this.ror_o32();
                return;
            }
            case 145: {
                this.salc();
                return;
            }
            case 214: {
                this.sar_o8();
                return;
            }
            case 221: {
                this.sar_o16();
                return;
            }
            case 228: {
                this.sar_o32();
                return;
            }
            case 9: {
                this.sbb_o8();
                return;
            }
            case 11: {
                this.sbb_o16();
                return;
            }
            case 10: {
                this.sbb_o32();
                return;
            }
            case 197: {
                this.scas_o8_a16();
                return;
            }
            case 198: {
                this.scas_o16_a16();
                return;
            }
            case 199: {
                this.scas_o32_a16();
                return;
            }
            case 365: {
                this.scas_o8_a32();
                return;
            }
            case 366: {
                this.scas_o16_a32();
                return;
            }
            case 367: {
                this.scas_o32_a32();
                return;
            }
            case 434: {
                this.setb();
                return;
            }
            case 435: {
                this.setnb();
                return;
            }
            case 438: {
                this.setbe();
                return;
            }
            case 439: {
                this.setnbe();
                return;
            }
            case 444: {
                this.setl();
                return;
            }
            case 445: {
                this.setnl();
                return;
            }
            case 446: {
                this.setle();
                return;
            }
            case 447: {
                this.setnle();
                return;
            }
            case 432: {
                this.seto();
                return;
            }
            case 433: {
                this.setno();
                return;
            }
            case 442: {
                this.setp();
                return;
            }
            case 443: {
                this.setnp();
                return;
            }
            case 440: {
                this.sets();
                return;
            }
            case 441: {
                this.setns();
                return;
            }
            case 436: {
                this.setz();
                return;
            }
            case 437: {
                this.setnz();
                return;
            }
            case 212: {
                this.shl_o8();
                return;
            }
            case 219: {
                this.shl_o16();
                return;
            }
            case 226: {
                this.shl_o32();
                return;
            }
            case 463: {
                this.shld_o16();
                return;
            }
            case 464: {
                this.shld_o32();
                return;
            }
            case 213: {
                this.shr_o8();
                return;
            }
            case 220: {
                this.shr_o16();
                return;
            }
            case 227: {
                this.shr_o32();
                return;
            }
            case 462: {
                this.shrd_o32();
                return;
            }
            case 461: {
                this.shrd_o16();
                return;
            }
            case 383: {
                this.sidt_o16();
                return;
            }
            case 384: {
                this.sidt_o32();
                return;
            }
            case 387: {
                this.smsw();
                return;
            }
            case 180: {
                this.stc();
                return;
            }
            case 184: {
                this.std();
                return;
            }
            case 182: {
                this.sti();
                return;
            }
            case 194: {
                this.stos_o8_a16();
                return;
            }
            case 195: {
                this.stos_o16_a16();
                return;
            }
            case 196: {
                this.stos_o32_a16();
                return;
            }
            case 362: {
                this.stos_o8_a32();
                return;
            }
            case 363: {
                this.stos_o16_a32();
                return;
            }
            case 364: {
                this.stos_o32_a32();
                return;
            }
            case 16: {
                this.sub_o8();
                return;
            }
            case 18: {
                this.sub_o16();
                return;
            }
            case 17: {
                this.sub_o32();
                return;
            }
            case 70: {
                this.test_o8();
                return;
            }
            case 72: {
                this.test_o16();
                return;
            }
            case 71: {
                this.test_o32();
                return;
            }
            case 92: {
                this.waitOp();
                return;
            }
            case 489: {
                this.xadd_o8();
                return;
            }
            case 490: {
                this.xadd_o16();
                return;
            }
            case 491: {
                this.xadd_o32();
                return;
            }
            case 73: {
                this.xchg_o8();
                return;
            }
            case 83: {
                this.xchg_o16();
                return;
            }
            case 82: {
                this.xchg_o32();
                return;
            }
            case 229: {
                this.xlat();
                return;
            }
            case 20: {
                this.xor_o8();
                return;
            }
            case 22: {
                this.xor_o16();
                return;
            }
            case 21: {
                this.xor_o32();
                return;
            }
            case 262: {
                this.eipUpdate();
                return;
            }
        }
        System.out.println("Real Mode: Unimplemented Opcode: " + this.microcodes[this.microcodesPosition - 1]);
        throw unimplemented;
    }

    private final void eipUpdate() {
        if (!this.eipUpdated) {
            this.eipUpdated = true;
            this.cpu.eip += this.cumulativeX86Length[this.microcodesPosition - 1];
        }
    }

    private final void bound_o16_a16() throws ProcessorException {
        int n = this.getIntOperand();
        short s = (short)n;
        short s2 = (short)(n >> 16);
        short s3 = this.getShortOperand();
        if (s3 < s || s3 > s2) {
            throw exceptionBR;
        }
    }

    private final void call_o16_a16() throws ProcessorException {
        short s = this.getShortOperand();
        if ((this.cpu.esp & 0xFFFF) < 2 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.eip);
        this.cpu.eip = this.cpu.eip + s & 0xFFFF;
    }

    private final void call_o32_a16() throws ProcessorException {
        int n = this.getIntOperand();
        if ((this.cpu.esp & 0xFFFF) < 4 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        if (this.cpu.eip + n > 65535) {
            throw exceptionGP;
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
        this.cpu.ss.setDoubleWord(this.cpu.esp & 0xFFFF, this.cpu.eip);
        this.cpu.eip += n;
    }

    private final void callf_o16_a16() throws ProcessorException {
        int n = this.getIntOperand();
        int n2 = n >>> 16;
        int n3 = n & 0xFFFF;
        if ((this.cpu.esp & 0xFFFF) < 4 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.cs.getSelector());
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.eip);
        this.cpu.eip = n3;
        this.cpu.cs.setSelector(n2);
    }

    private final void calln_o16_a16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        if ((this.cpu.esp & 0xFFFF) < 2 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.eip);
        this.cpu.eip = n;
    }

    private final void cpuid() {
        switch (this.cpu.eax) {
            case 0: {
                this.cpu.eax = 3;
                this.cpu.ebx = 1970169159;
                this.cpu.edx = 1231384169;
                this.cpu.ecx = 1818588270;
                return;
            }
            case 1: {
                this.cpu.eax = 1667;
                this.cpu.ebx = 0;
                this.cpu.ecx = 0;
                int n = 0;
                n |= 0x100;
                n |= 0x10;
                n |= 0x20;
                n |= 8;
                n |= 0x2000;
                this.cpu.edx = n |= 0x800;
                return;
            }
        }
        this.cpu.eax = 0;
        this.cpu.ebx = 0;
        this.cpu.ecx = 0;
        this.cpu.edx = 0;
    }

    private final void enter_o16_a16() throws ProcessorException {
        int n = this.getIntOperand();
        int n2 = (0xFF & n) % 32;
        int n3 = n >>> 16;
        int n4 = this.cpu.esp;
        int n5 = this.cpu.ebp;
        if (n2 == 0 ? (n4 & 0xFFFF) < 2 + n3 && (n4 & 0xFFFF) > 0 : (n4 & 0xFFFF) < 2 + n3 + 2 * n2 && (n4 & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        n4 = n4 & 0xFFFF0000 | n4 - 2 & 0xFFFF;
        this.cpu.ss.setWord(n4 & 0xFFFF, (short)n5);
        int n6 = n4 & 0xFFFF;
        if (n2 != 0) {
            while (--n2 != 0) {
                n5 = n5 & 0xFFFF0000 | n5 - 2 & 0xFFFF;
                n4 = n4 & 0xFFFF0000 | n4 - 2 & 0xFFFF;
                this.cpu.ss.setWord(n4 & 0xFFFF, this.cpu.ss.getWord(n5 & 0xFFFF));
            }
            n4 = n4 & 0xFFFF0000 | n4 - 2 & 0xFFFF;
            this.cpu.ss.setWord(n4 & 0xFFFF, (short)n6);
        }
        this.cpu.ebp = n5 & 0xFFFF0000 | n6 & 0xFFFF;
        this.cpu.esp = n4 & 0xFFFF0000 | n4 - n3 & 0xFFFF;
    }

    private final void fnstenv_14() {
        Segment segment = this.getSegmentOperand();
        int n = this.getAddressOperand();
        segment.setWord(n, (short)this.fpu.getControl());
        segment.setWord(n + 2, (short)this.fpu.getStatus());
        segment.setWord(n + 4, (short)this.fpu.getTagWord());
        segment.setWord(n + 6, (short)this.fpu.lastIP);
        int n2 = this.fpu.lastOpcode | (int)(this.fpu.lastIP << 12);
        segment.setWord(n + 8, (short)n2);
        segment.setWord(n + 10, (short)this.fpu.lastData);
        n2 = (int)(this.fpu.lastData << 12);
        segment.setWord(n + 12, (short)n2);
    }

    private final void hlt() throws ProcessorException {
        while ((this.cpu.getInterruptFlags() & 1) == 0 || !this.cpu.eflagsInterruptEnable) {
            this.cpu.waitForInterrupt(50L);
            this.cpu.processClock();
        }
        return;
    }

    private final void in_o8_o8() throws ProcessorException {
        int n = 0xFF & this.getByteOperand();
        this.setByteOperand((byte)this.cpu.ioports.ioPortReadByte(n));
    }

    private final void in_o16_o8() throws ProcessorException {
        int n = 0xFF & this.getByteOperand();
        this.setShortOperand((short)this.cpu.ioports.ioPortReadWord(n));
    }

    private final void in_o32_o8() throws ProcessorException {
        int n = 0xFF & this.getByteOperand();
        this.setIntOperand(this.cpu.ioports.ioPortReadLong(n));
    }

    private final void in_o8_o16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        this.setByteOperand((byte)this.cpu.ioports.ioPortReadByte(n));
    }

    private final void in_o16_o16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        this.setShortOperand((short)this.cpu.ioports.ioPortReadWord(n));
    }

    private final void in_o32_o16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        this.setIntOperand(this.cpu.ioports.ioPortReadLong(n));
    }

    private final void ins_o8_a16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = this.cpu.edi & 0xFFFF;
        byte by = (byte)this.cpu.ioports.ioPortReadByte(n);
        this.setByteOperand(by);
        n2 = this.cpu.eflagsDirection ? --n2 : ++n2;
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.edi |= n2 & 0xFFFF;
    }

    private final void into_o16_a16() throws ProcessorException {
        if (!this.cpu.getOverflowFlag()) {
            return;
        }
        int n = 4;
        if ((this.cpu.esp & 0xFFFF) < 6 && (this.cpu.esp & 0xFFFF) > 0) {
            throw new IllegalStateException("SS Processor Exception Thrown in \"handleInterrupt(" + n + ")\"");
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        int n2 = this.cpu.getEFlags() & 0xFFFF;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)n2);
        this.cpu.eflagsInterruptEnable = false;
        this.cpu.eflagsInterruptEnableSoon = false;
        this.cpu.eflagsTrap = false;
        this.cpu.eflagsAlignmentCheck = false;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.cs.getSelector());
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.eip);
        this.cpu.eip = 0xFFFF & this.cpu.idtr.getWord(4 * n);
        this.cpu.cs.setSelector(0xFFFF & this.cpu.idtr.getWord(4 * n + 2));
    }

    private final void int_o16_a16() throws ProcessorException {
        int n = 0xFF & this.getByteOperand();
        if (n == 0) {
            throw unimplemented;
        }
        if ((this.cpu.esp & 0xFFFF) < 6 && (this.cpu.esp & 0xFFFF) > 0) {
            throw new IllegalStateException("SS Processor Exception Thrown in \"handleInterrupt(" + n + ")\"");
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        int n2 = this.cpu.getEFlags() & 0xFFFF;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)n2);
        this.cpu.eflagsInterruptEnable = false;
        this.cpu.eflagsInterruptEnableSoon = false;
        this.cpu.eflagsTrap = false;
        this.cpu.eflagsAlignmentCheck = false;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.cs.getSelector());
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.eip);
        this.cpu.eip = 0xFFFF & this.cpu.idtr.getWord(4 * n);
        this.cpu.cs.setSelector(0xFFFF & this.cpu.idtr.getWord(4 * n + 2));
    }

    private final void int3_o16_a16() throws ProcessorException {
        int n = 3;
        if ((this.cpu.esp & 0xFFFF) < 6 && (this.cpu.esp & 0xFFFF) > 0) {
            throw new IllegalStateException("SS Processor Exception Thrown in \"handleInterrupt(" + n + ")\"");
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        int n2 = this.cpu.getEFlags() & 0xFFFF;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)n2);
        this.cpu.eflagsInterruptEnable = false;
        this.cpu.eflagsInterruptEnableSoon = false;
        this.cpu.eflagsTrap = false;
        this.cpu.eflagsAlignmentCheck = false;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.cs.getSelector());
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | 0xFFFF & this.cpu.esp - 2;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, (short)this.cpu.eip);
        this.cpu.eip = 0xFFFF & this.cpu.idtr.getWord(4 * n);
        this.cpu.cs.setSelector(0xFFFF & this.cpu.idtr.getWord(4 * n + 2));
    }

    private final void iret_o16_a16() throws ProcessorException {
        this.cpu.eip = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
        this.cpu.cs.setSelector(this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
        short s = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
        int n = this.cpu.getEFlags() & 0xFFFF0000;
        this.cpu.setEFlags(n | s & 0xFFFF);
    }

    private final void jmp_o16_far() throws ProcessorException {
        int n = this.getIntOperand();
        this.cpu.eip = 0xFFFF & n;
        this.cpu.cs.setSelector(0xFFFF & n >>> 16);
    }

    private final void jmp_o32_far() throws ProcessorException {
        long l = this.getLongOperand();
        this.cpu.eip = (int)l;
        this.cpu.cs.setSelector(0xFFFF & (int)(l >>> 32));
    }

    private final void jmp_o16_near_relative() throws ProcessorException {
        short s = this.getShortOperand();
        this.cpu.eip = this.cpu.eip + s & 0xFFFF;
    }

    private final void jmp_o16_near_absolute() throws ProcessorException {
        short s = this.getShortOperand();
        this.cpu.eip = s & 0xFFFF;
    }

    private final void jmp_o8_short() throws ProcessorException {
        byte by = this.getByteOperand();
        this.cpu.eip = this.cpu.eip + by & 0xFFFF;
    }

    private final void jcxz_a16() throws ProcessorException {
        byte by = this.getByteOperand();
        if ((this.cpu.ecx & 0xFFFF) != 0) {
            return;
        }
        this.cpu.eip = this.cpu.eip + by & 0xFFFF;
    }

    private final void jcxz_a32() throws ProcessorException {
        byte by = this.getByteOperand();
        if (this.cpu.ecx != 0) {
            return;
        }
        this.cpu.eip = this.cpu.eip + by & 0xFFFF;
    }

    private final void jb_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsCarry) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jb_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (this.cpu.eflagsCarry) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jb_o32() throws ProcessorException {
        int n = this.getIntOperand();
        if (this.cpu.eflagsCarry) {
            int n2 = this.cpu.eip + n;
            this.cpu.cs.checkAddress(n2);
            this.cpu.eip = n2;
        }
    }

    private final void jnb_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsCarry) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jnb_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsCarry) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jbe_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsCarry || this.cpu.eflagsZero) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jbe_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (this.cpu.eflagsCarry || this.cpu.eflagsZero) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jnbe_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsCarry && !this.cpu.eflagsZero) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jnbe_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsCarry && !this.cpu.eflagsZero) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jl_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jl_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jnl_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jnl_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jle_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsZero || this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jle_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (this.cpu.eflagsZero || this.cpu.eflagsSign != this.cpu.eflagsOverflow) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jnle_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsZero && this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jnle_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsZero && this.cpu.eflagsSign == this.cpu.eflagsOverflow) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jo_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsOverflow) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jo_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (this.cpu.eflagsOverflow) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jno_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsOverflow) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jno_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsOverflow) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jp_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsParity) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jp_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (this.cpu.eflagsParity) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jnp_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsParity) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jnp_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsParity) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void js_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsSign) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void js_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (this.cpu.eflagsSign) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jns_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsSign) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jns_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsSign) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jz_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (this.cpu.eflagsZero) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jz_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (this.cpu.eflagsZero) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void jnz_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        if (!this.cpu.eflagsZero) {
            this.cpu.eip += by;
            if ((this.cpu.eip & 0xFFFF0000) == 0) {
                return;
            }
            this.cpu.eip -= by;
            throw exceptionGP;
        }
    }

    private final void jnz_o16() throws ProcessorException {
        short s = this.getShortOperand();
        if (!this.cpu.eflagsZero) {
            this.cpu.eip += s;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void lahf() {
        int n = 512;
        if (this.cpu.eflagsSign) {
            n |= 0x8000;
        }
        if (this.cpu.eflagsZero) {
            n |= 0x4000;
        }
        if (this.cpu.eflagsAuxiliaryCarry) {
            n |= 0x1000;
        }
        if (this.cpu.eflagsParity) {
            n |= 0x400;
        }
        if (this.cpu.eflagsCarry) {
            n |= 0x100;
        }
        this.cpu.eax &= 0xFFFF00FF;
        this.cpu.eax |= n;
    }

    private final void sahf() {
        int n = this.cpu.eax & 0xFF00;
        this.cpu.eflagsCarry = 0 != (n & 0x100);
        this.cpu.eflagsParity = 0 != (n & 0x400);
        this.cpu.eflagsAuxiliaryCarry = 0 != (n & 0x1000);
        this.cpu.eflagsZero = 0 != (n & 0x4000);
        this.cpu.eflagsSign = 0 != (n & 0x8000);
    }

    private final void leave_o16_a16() throws ProcessorException {
        int n = this.cpu.esp & 0xFFFF0000 | this.cpu.ebp & 0xFFFF;
        int n2 = this.cpu.ebp & 0xFFFF0000 | this.cpu.ss.getWord(n & 0xFFFF) & 0xFFFF;
        if (n2 > 65535 | this.cpu.ebp < 0) {
            System.out.println("Throwing dodgy leave exception");
            throw exceptionGP;
        }
        this.cpu.esp = n & 0xFFFF0000 | n + 2 & 0xFFFF;
        this.cpu.ebp = n2;
    }

    private final void les_o16_a16() throws ProcessorException {
        int n = this.getIntOperand();
        this.setShortOperand((short)n);
        this.cpu.es.setSelector(n >>> 16);
    }

    private final void lds_o16_a16() throws ProcessorException {
        int n = this.getIntOperand();
        this.setShortOperand((short)n);
        this.cpu.ds.setSelector(n >>> 16);
    }

    private final void lds_o32_a16() throws ProcessorException {
        long l = this.getLongOperand();
        this.setIntOperand((int)l);
        this.cpu.ds.setSelector((int)(l >> 32) & 0xFFFF);
    }

    private final void lfs_o16_a16() throws ProcessorException {
        int n = this.getIntOperand();
        this.setShortOperand((short)n);
        this.cpu.fs.setSelector(n >>> 16);
    }

    private final void lgs_o16_a16() throws ProcessorException {
        int n = this.getIntOperand();
        this.setShortOperand((short)n);
        this.cpu.gs.setSelector(n >>> 16);
    }

    private final void lgdt_o16() throws ProcessorException {
        long l = this.getLongOperand();
        this.cpu.gdtr = this.cpu.createDescriptorTableSegment((int)(l >> 16 & 0xFFFFFFL), (int)(l & 0xFFFFL));
    }

    private final void lgdt_o32() throws ProcessorException {
        long l = this.getLongOperand();
        this.cpu.gdtr = this.cpu.createDescriptorTableSegment((int)(l >> 16), (int)(l & 0xFFFFL));
    }

    private final void lidt_o16() throws ProcessorException {
        long l = this.getLongOperand();
        this.cpu.idtr = this.cpu.createDescriptorTableSegment((int)(l >>> 16 & 0xFFFFFFL), (int)(l & 0xFFFFL));
    }

    private final void lidt_o32() throws ProcessorException {
        long l = this.getLongOperand();
        this.cpu.idtr = this.cpu.createDescriptorTableSegment((int)(l >>> 16), (int)(l & 0xFFFFL));
    }

    private final void lmsw() throws ProcessorException {
        short s = this.getShortOperand();
        this.cpu.setCR0(this.cpu.getCR0() & 0xFFFFFFF0 | s & 0xF);
    }

    private final void loop_o16_a16() throws ProcessorException {
        byte by = this.getByteOperand();
        this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | --this.cpu.ecx & 0xFFFF;
        if ((this.cpu.ecx & 0xFFFF) != 0) {
            this.cpu.eip += by;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void loop_o32_a16() throws ProcessorException {
        byte by = this.getByteOperand();
        this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | --this.cpu.ecx & 0xFFFF;
        if ((this.cpu.ecx & 0xFFFF) != 0) {
            this.cpu.eip += by;
        }
    }

    private final void loopz_o16_a16() throws ProcessorException {
        byte by = this.getByteOperand();
        this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | --this.cpu.ecx & 0xFFFF;
        if ((this.cpu.ecx & 0xFFFF) != 0 && this.cpu.eflagsZero) {
            this.cpu.eip += by;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void loopnz_o16_a16() throws ProcessorException {
        byte by = this.getByteOperand();
        this.cpu.ecx = this.cpu.ecx & 0xFFFF0000 | --this.cpu.ecx & 0xFFFF;
        if ((this.cpu.ecx & 0xFFFF) != 0 && !this.cpu.eflagsZero) {
            this.cpu.eip += by;
            this.cpu.eip &= 0xFFFF;
        }
    }

    private final void lss_o16_a16() throws ProcessorException {
        int n = this.getIntOperand();
        this.setShortOperand((short)n);
        this.cpu.ss.setSelector(n >> 16 & 0xFFFF);
    }

    private final void lss_o32_a16() throws ProcessorException {
        long l = this.getLongOperand();
        this.setIntOperand((int)l);
        this.cpu.ss.setSelector((int)(l >> 32) & 0xFFFF);
    }

    private final void mov_to_cr_o32() throws ProcessorException {
        int n = this.getIntOperand();
        switch (this.microcodes[this.microcodesPosition++]) {
            case 30: {
                this.cpu.setCR0(n);
                break;
            }
            default: {
                throw unimplemented;
            }
        }
    }

    private final void out_o8_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        int n = 0xFF & this.getByteOperand();
        this.cpu.ioports.ioPortWriteByte(n, 0xFF & by);
    }

    private final void out_o8_o16() throws ProcessorException {
        short s = this.getShortOperand();
        int n = 0xFF & this.getByteOperand();
        this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & s);
    }

    private final void out_o8_o32() throws ProcessorException {
        int n = this.getIntOperand();
        int n2 = 0xFF & this.getByteOperand();
        this.cpu.ioports.ioPortWriteLong(n2, n);
    }

    private final void out_o16_o8() throws ProcessorException {
        byte by = this.getByteOperand();
        int n = 0xFFFF & this.getShortOperand();
        this.cpu.ioports.ioPortWriteByte(n, 0xFF & by);
    }

    private final void out_o16_o16() throws ProcessorException {
        short s = this.getShortOperand();
        int n = 0xFFFF & this.getShortOperand();
        this.cpu.ioports.ioPortWriteWord(n, 0xFFFF & s);
    }

    private final void out_o16_o32() throws ProcessorException {
        int n = this.getIntOperand();
        int n2 = 0xFFFF & this.getShortOperand();
        this.cpu.ioports.ioPortWriteLong(n2, n);
    }

    private final void outs_o8_a16() throws ProcessorException {
        int n = this.cpu.esi & 0xFFFF;
        int n2 = 0xFFFF & this.getShortOperand();
        int n3 = this.getByteOperand() & 0xFF;
        this.cpu.ioports.ioPortWriteByte(n2, n3);
        n = this.cpu.eflagsDirection ? --n : ++n;
        this.cpu.esi &= 0xFFFF0000;
        this.cpu.esi |= n & 0xFFFF;
    }

    private final void outs_o16_a16() throws ProcessorException {
        int n = this.cpu.esi & 0xFFFF;
        int n2 = 0xFFFF & this.getShortOperand();
        int n3 = this.getShortOperand() & 0xFFFF;
        this.cpu.ioports.ioPortWriteWord(n2, n3);
        n = this.cpu.eflagsDirection ? (n -= 2) : (n += 2);
        this.cpu.esi &= 0xFFFF0000;
        this.cpu.esi |= n & 0xFFFF;
    }

    private final void outs_o32_a16() throws ProcessorException {
        int n = this.cpu.esi & 0xFFFF;
        int n2 = 0xFFFF & this.getShortOperand();
        int n3 = this.getIntOperand();
        this.cpu.ioports.ioPortWriteByte(n2, n3);
        n = this.cpu.eflagsDirection ? (n -= 4) : (n += 4);
        this.cpu.esi &= 0xFFFF0000;
        this.cpu.esi |= n & 0xFFFF;
    }

    private final void pop_o16_a16() throws ProcessorException {
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
        short s = this.cpu.ss.getWord(this.cpu.esp - 2 & 0xFFFF);
        if (this.microcodes[this.microcodesPosition] == 26) {
            this.cpu.eflagsInterruptEnable = false;
        }
        this.setShortOperand(s);
    }

    private final void pop_o32_a16() throws ProcessorException {
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp - 4 & 0xFFFF);
        if (this.microcodes[this.microcodesPosition] == 26) {
            this.cpu.eflagsInterruptEnable = false;
        }
        this.setIntOperand(n);
    }

    private final void popa_o16_a16() throws ProcessorException {
        int n = 0xFFFF & this.cpu.esp;
        this.cpu.edi &= 0xFFFF0000;
        this.cpu.esi &= 0xFFFF0000;
        this.cpu.ebp &= 0xFFFF0000;
        this.cpu.ebx &= 0xFFFF0000;
        this.cpu.edx &= 0xFFFF0000;
        this.cpu.ecx &= 0xFFFF0000;
        this.cpu.eax &= 0xFFFF0000;
        this.cpu.edi |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & n);
        this.cpu.esi |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        this.cpu.ebp |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        n += 2;
        this.cpu.ebx |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        this.cpu.edx |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        this.cpu.ecx |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        this.cpu.eax |= 0xFFFF & this.cpu.ss.getWord(0xFFFF & (n += 2));
        n += 2;
        this.cpu.esp &= 0xFFFF0000;
        this.cpu.esp |= (n &= 0xFFFF);
    }

    private final void popa_o32_a16() throws ProcessorException {
        int n = 0xFFFF & this.cpu.esp;
        this.cpu.edi = this.cpu.ss.getDoubleWord(0xFFFF & n);
        this.cpu.esi = this.cpu.ss.getDoubleWord(0xFFFF & (n += 4));
        this.cpu.ebp = this.cpu.ss.getDoubleWord(0xFFFF & (n += 4));
        this.cpu.ebx = this.cpu.ss.getDoubleWord(0xFFFF & (n += 8));
        this.cpu.edx = this.cpu.ss.getDoubleWord(0xFFFF & (n += 4));
        this.cpu.ecx = this.cpu.ss.getDoubleWord(0xFFFF & (n += 4));
        this.cpu.eax = this.cpu.ss.getDoubleWord(0xFFFF & (n += 4));
        n += 4;
        this.cpu.esp &= 0xFFFF0000;
        this.cpu.esp |= (n &= 0xFFFF);
    }

    private final void popf_o16_a16() throws ProcessorException {
        int n = 0xFFFF & this.cpu.ss.getWord(this.cpu.esp & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
        int n2 = this.cpu.getEFlags() & 0xFFFF0000;
        this.cpu.setEFlags(n2 |= n);
    }

    private final void popf_o32_a16() throws ProcessorException {
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
        boolean bl = this.cpu.eflagsVirtual8086Mode;
        this.cpu.setEFlags(n);
        this.cpu.eflagsVirtual8086Mode = bl;
        this.cpu.eflagsVirtualInterrupt = false;
        this.cpu.eflagsVirtualInterruptPending = false;
    }

    private final void push_o16_a16() throws ProcessorException {
        short s = this.getShortOperand();
        if ((this.cpu.esp & 0xFFFF) < 2 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, s);
    }

    private final void push_o32_a16() throws ProcessorException {
        int n = 0;
        switch (this.microcodes[this.microcodesPosition]) {
            case 28: 
            case 29: {
                n = this.getIntOperand();
                n &= 0xFFFF;
                break;
            }
            default: {
                n = this.getIntOperand();
            }
        }
        if ((this.cpu.esp & 0xFFFF) < 4 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
        this.cpu.ss.setDoubleWord(this.cpu.esp & 0xFFFF, n);
    }

    private final void pusha_o16_a16() throws ProcessorException {
        int n = this.cpu.esp & 0xFFFF;
        int n2 = this.cpu.esp;
        if (n < 16 && n > 0) {
            throw exceptionGP;
        }
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.eax);
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.ecx);
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.edx);
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.ebx);
        this.cpu.ss.setWord(n -= 2, (short)n2);
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.ebp);
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.esi);
        this.cpu.ss.setWord(n -= 2, (short)this.cpu.edi);
        this.cpu.esp &= 0xFFFF0000;
        this.cpu.esp |= (n &= 0xFFFF);
    }

    private final void pusha_o32_a16() throws ProcessorException {
        int n = this.cpu.esp & 0xFFFF;
        int n2 = this.cpu.esp;
        if (n < 32 && n > 0) {
            throw exceptionGP;
        }
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.eax);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ecx);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.edx);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ebx);
        this.cpu.ss.setDoubleWord(n -= 4, n2);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.ebp);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.esi);
        this.cpu.ss.setDoubleWord(n -= 4, this.cpu.edi);
        this.cpu.esp &= 0xFFFF0000;
        this.cpu.esp |= (n &= 0xFFFF);
    }

    private final void pushf_o16_a16() throws ProcessorException {
        if ((this.cpu.esp & 0xFFFF) < 2 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 2 & 0xFFFF;
        short s = (short)this.cpu.getEFlags();
        this.cpu.ss.setWord(this.cpu.esp & 0xFFFF, s);
    }

    private final void pushf_o32_a16() throws ProcessorException {
        if ((this.cpu.esp & 0xFFFF) < 4 && (this.cpu.esp & 0xFFFF) > 0) {
            throw exceptionSS;
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp - 4 & 0xFFFF;
        int n = this.cpu.getEFlags() & 0xFCFFFF;
        this.cpu.ss.setDoubleWord(this.cpu.esp & 0xFFFF, n);
    }

    private final void rep_ins_o8_a16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            this.microcodesPosition = n2;
            int n3 = this.cpu.edi & 0xFFFF;
            byte by = (byte)this.cpu.ioports.ioPortReadByte(n);
            this.setByteOperand(by);
            n3 = this.cpu.eflagsDirection ? --n3 : ++n3;
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n3 & 0xFFFF;
            --this.cpu.ecx;
        }
    }

    private final void rep_ins_o16_a16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            this.microcodesPosition = n2;
            int n3 = this.cpu.edi & 0xFFFF;
            short s = (short)this.cpu.ioports.ioPortReadWord(n);
            this.setShortOperand(s);
            n3 = this.cpu.eflagsDirection ? (n3 -= 2) : (n3 += 2);
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n3 & 0xFFFF;
            --this.cpu.ecx;
        }
    }

    private final void rep_ins_o32_a16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            this.microcodesPosition = n2;
            int n3 = this.cpu.edi & 0xFFFF;
            int n4 = this.cpu.ioports.ioPortReadLong(n);
            this.setIntOperand(n4);
            n3 = this.cpu.eflagsDirection ? (n3 -= 4) : (n3 += 4);
            this.cpu.edi &= 0xFFFF0000;
            this.cpu.edi |= n3 & 0xFFFF;
            --this.cpu.ecx;
        }
    }

    private final void rep_outs_o8_a16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            this.microcodesPosition = n2;
            int n3 = this.cpu.esi & 0xFFFF;
            int n4 = this.getByteOperand() & 0xFF;
            this.cpu.ioports.ioPortWriteByte(n, n4);
            n3 = this.cpu.eflagsDirection ? --n3 : ++n3;
            this.cpu.esi &= 0xFFFF0000;
            this.cpu.esi |= n3 & 0xFFFF;
            --this.cpu.ecx;
        }
    }

    private final void rep_outs_o16_a16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            this.microcodesPosition = n2;
            int n3 = this.cpu.esi & 0xFFFF;
            int n4 = this.getShortOperand() & 0xFFFF;
            this.cpu.ioports.ioPortWriteWord(n, n4);
            n3 = this.cpu.eflagsDirection ? (n3 -= 2) : (n3 += 2);
            this.cpu.esi &= 0xFFFF0000;
            this.cpu.esi |= n3 & 0xFFFF;
            --this.cpu.ecx;
        }
    }

    private final void rep_outs_o32_a16() throws ProcessorException {
        int n = 0xFFFF & this.getShortOperand();
        int n2 = this.microcodesPosition;
        this.skipOperand();
        while ((this.cpu.ecx & 0xFFFF) != 0) {
            this.microcodesPosition = n2;
            int n3 = this.cpu.esi & 0xFFFF;
            int n4 = this.getIntOperand();
            this.cpu.ioports.ioPortWriteLong(n, n4);
            n3 = this.cpu.eflagsDirection ? (n3 -= 4) : (n3 += 4);
            this.cpu.esi &= 0xFFFF0000;
            this.cpu.esi |= n3 & 0xFFFF;
            --this.cpu.ecx;
        }
    }

    private final void ret_o16_a16() throws ProcessorException {
        this.cpu.eip = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 & 0xFFFF;
    }

    private final void ret_o32_a16() throws ProcessorException {
        int n = this.cpu.ss.getDoubleWord(this.cpu.esp & 0xFFFF);
        if (n > 65535) {
            throw exceptionGP;
        }
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
        this.cpu.eip = n;
    }

    private final void ret_iw_o16_a16() throws ProcessorException {
        short s = this.getShortOperand();
        this.cpu.eip = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF;
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 2 + s & 0xFFFF;
    }

    private final void retf_o16_a16() throws ProcessorException {
        this.cpu.eip = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF;
        this.cpu.cs.setSelector(this.cpu.ss.getWord(this.cpu.esp + 2 & 0xFFFF) & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 & 0xFFFF;
    }

    private final void retf_iw_o16_a16() throws ProcessorException {
        short s = this.getShortOperand();
        this.cpu.eip = this.cpu.ss.getWord(this.cpu.esp & 0xFFFF) & 0xFFFF;
        this.cpu.cs.setSelector(this.cpu.ss.getWord(this.cpu.esp + 2 & 0xFFFF) & 0xFFFF);
        this.cpu.esp = this.cpu.esp & 0xFFFF0000 | this.cpu.esp + 4 + s & 0xFFFF;
    }

    private final void salc() {
        this.cpu.eax = this.cpu.eflagsCarry ? (this.cpu.eax |= 0xFF) : (this.cpu.eax &= 0xFFFFFF00);
    }

    private final void sidt_o16() throws ProcessorException {
        long l = (long)this.cpu.idtr.getLimit() & 0xFFFFL | ((long)this.cpu.idtr.getBase() & 0xFFFFFFL) << 16;
        this.setLongOperand(l);
    }

    private final void sidt_o32() throws ProcessorException {
        long l = (long)this.cpu.idtr.getLimit() & 0xFFFFL | ((long)this.cpu.idtr.getBase() & 0xFFFFFFFFL) << 16;
        this.setLongOperand(l);
    }

    private final void smsw() throws ProcessorException {
        this.setShortOperand((short)this.cpu.getCR0());
    }

    protected final void loadSegment(int n, int n2) {
        switch (n) {
            case 25: {
                this.cpu.cs.setSelector(0xFFFF & n2);
                return;
            }
            case 27: {
                this.cpu.ds.setSelector(0xFFFF & n2);
                return;
            }
            case 26: {
                this.cpu.ss.setSelector(0xFFFF & n2);
                return;
            }
            case 24: {
                this.cpu.es.setSelector(0xFFFF & n2);
                return;
            }
            case 28: {
                this.cpu.fs.setSelector(0xFFFF & n2);
                return;
            }
            case 29: {
                this.cpu.gs.setSelector(0xFFFF & n2);
                return;
            }
        }
    }

    private final void standardFlags(byte by) {
        this.cpu.eflagsZero = by == 0;
        this.cpu.eflagsParity = parityMap[by & 0xFF];
        this.cpu.eflagsSign = by < 0;
    }

    private final void standardFlags(short s) {
        this.cpu.eflagsZero = s == 0;
        this.cpu.eflagsParity = parityMap[s & 0xFF];
        this.cpu.eflagsSign = s < 0;
    }

    private final void standardFlags(int n) {
        this.cpu.eflagsZero = n == 0;
        this.cpu.eflagsParity = parityMap[n & 0xFF];
        this.cpu.eflagsSign = n < 0;
    }

    private final void bitwiseFlags(byte by) {
        this.cpu.eflagsOverflow = false;
        this.cpu.eflagsCarry = false;
        this.standardFlags(by);
    }

    private final void bitwiseFlags(short s) {
        this.cpu.eflagsOverflow = false;
        this.cpu.eflagsCarry = false;
        this.standardFlags(s);
    }

    private final void bitwiseFlags(int n) {
        this.cpu.eflagsOverflow = false;
        this.cpu.eflagsCarry = false;
        this.standardFlags(n);
    }

    public int immediateCount(int n) {
        return RealModeDecoder.immediateCount(n);
    }

    public int operandCount(int n) {
        return RealModeDecoder.operandCount(n);
    }
}

