/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.CodeBlockCompiler;
import org.jpc.emulator.memory.codeblock.InstructionSource;
import org.jpc.emulator.memory.codeblock.ObjectTreeCache;
import org.jpc.emulator.memory.codeblock.ObjectTreeStateMachine;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;

public class CachedInstructionCompiler
implements CodeBlockCompiler,
InstructionSource,
ObjectTreeCache {
    private CodeBlockCompiler underlying;
    private int operationBufferOffset = 0;
    private int microcodeBufferOffset = 0;
    private int[] bufferMicrocodes = new int[100];
    private int[] bufferLength = new int[100];
    private int[] bufferX86Length = new int[100];
    private int operationReplayIndex;
    private int microcodeReplayIndex;
    private ObjectTreeStateMachine realModeTree;
    private ObjectTreeStateMachine protectedModeTree;
    private int foundRealModeBlockCount;
    private int addedRealModeBlockCount;
    private int foundProtectedModeBlockCount;
    private int addedProtectedModeBlockCount;

    public CachedInstructionCompiler(CodeBlockCompiler codeBlockCompiler) {
        this.underlying = codeBlockCompiler;
        this.realModeTree = new ObjectTreeStateMachine();
        this.protectedModeTree = new ObjectTreeStateMachine();
        this.addedRealModeBlockCount = 0;
        this.foundRealModeBlockCount = 0;
        this.addedProtectedModeBlockCount = 0;
        this.foundProtectedModeBlockCount = 0;
    }

    public boolean getNext() {
        ++this.operationReplayIndex;
        return this.operationReplayIndex < this.operationBufferOffset;
    }

    public int getMicrocode() {
        return this.bufferMicrocodes[this.microcodeReplayIndex++];
    }

    public int getLength() {
        return this.bufferLength[this.operationReplayIndex];
    }

    public int getX86Length() {
        return this.bufferX86Length[this.operationReplayIndex];
    }

    public CodeBlock getCodeBlock(ObjectTreeStateMachine objectTreeStateMachine, InstructionSource instructionSource) {
        Object object = null;
        this.microcodeBufferOffset = 0;
        this.operationBufferOffset = 0;
        while (instructionSource.getNext()) {
            Object object2;
            int n = instructionSource.getLength();
            try {
                this.bufferLength[this.operationBufferOffset] = n;
                this.bufferX86Length[this.operationBufferOffset] = instructionSource.getX86Length();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int[] nArray = new int[this.bufferLength.length * 2];
                object2 = new int[this.bufferX86Length.length * 2];
                System.arraycopy(this.bufferLength, 0, nArray, 0, this.bufferLength.length);
                System.arraycopy(this.bufferX86Length, 0, object2, 0, this.bufferX86Length.length);
                this.bufferLength = nArray;
                this.bufferX86Length = object2;
                this.bufferLength[this.operationBufferOffset] = n;
                this.bufferX86Length[this.operationBufferOffset] = instructionSource.getX86Length();
            }
            ++this.operationBufferOffset;
            for (int i = 0; i < n; ++i) {
                int n2 = instructionSource.getMicrocode();
                objectTreeStateMachine.stepTree(n2);
                object2 = (CodeBlock)objectTreeStateMachine.getObjectAtState();
                if (object2 != null) {
                    object = object2;
                }
                try {
                    this.bufferMicrocodes[this.microcodeBufferOffset] = n2;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    int[] nArray = new int[this.bufferMicrocodes.length * 2];
                    System.arraycopy(this.bufferMicrocodes, 0, nArray, 0, this.bufferMicrocodes.length);
                    this.bufferMicrocodes = nArray;
                    this.bufferMicrocodes[this.microcodeBufferOffset] = n2;
                }
                ++this.microcodeBufferOffset;
            }
        }
        return object;
    }

    public RealModeCodeBlock getRealModeCodeBlock(InstructionSource instructionSource) {
        this.realModeTree.resetTreeState();
        CodeBlock codeBlock = this.getCodeBlock(this.realModeTree, instructionSource);
        if (codeBlock == null) {
            this.operationReplayIndex = -1;
            this.microcodeReplayIndex = 0;
            codeBlock = this.underlying.getRealModeCodeBlock(this);
            if (this.operationBufferOffset > 0) {
                this.realModeTree.setObjectAtState(codeBlock);
                ++this.addedRealModeBlockCount;
            }
        } else {
            ++this.foundRealModeBlockCount;
        }
        return (RealModeCodeBlock)codeBlock;
    }

    public ProtectedModeCodeBlock getProtectedModeCodeBlock(InstructionSource instructionSource) {
        this.protectedModeTree.resetTreeState();
        CodeBlock codeBlock = this.getCodeBlock(this.protectedModeTree, instructionSource);
        if (codeBlock == null) {
            this.operationReplayIndex = -1;
            this.microcodeReplayIndex = 0;
            codeBlock = this.underlying.getProtectedModeCodeBlock(this);
            if (this.operationBufferOffset > 0) {
                this.protectedModeTree.setObjectAtState(codeBlock);
                ++this.addedProtectedModeBlockCount;
            }
        } else {
            ++this.foundProtectedModeBlockCount;
        }
        return (ProtectedModeCodeBlock)codeBlock;
    }

    public ObjectTreeStateMachine getObjectTree() {
        return this.realModeTree;
    }

    public long getAddedCount() {
        return this.addedRealModeBlockCount;
    }

    public long getFoundCount() {
        return this.foundRealModeBlockCount;
    }
}

