/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import org.jpc.emulator.memory.codeblock.ByteSource;
import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.CodeBlockCompiler;
import org.jpc.emulator.memory.codeblock.CodeBlockFactory;
import org.jpc.emulator.memory.codeblock.Decoder;
import org.jpc.emulator.memory.codeblock.ObjectTreeCache;
import org.jpc.emulator.memory.codeblock.ObjectTreeStateMachine;
import org.jpc.emulator.memory.codeblock.ProtectedModeCodeBlock;
import org.jpc.emulator.memory.codeblock.RealModeCodeBlock;

public class CachedByteCodeBlockFactory
implements CodeBlockFactory,
ByteSource,
ObjectTreeCache {
    private Decoder decoder;
    private CodeBlockCompiler compiler;
    private ByteSource source;
    private int bufferOffset;
    private byte[] bufferBytes;
    private int replayIndex;
    private ObjectTreeStateMachine codeBlockTree;
    protected ObjectTreeStateMachine realModeTree;
    protected ObjectTreeStateMachine protectedModeTree;
    protected int foundRealModeBlockCount;
    protected int addedRealModeBlockCount;
    protected int foundProtectedModeBlockCount;
    protected int addedProtectedModeBlockCount;

    public CachedByteCodeBlockFactory(Decoder decoder, CodeBlockCompiler codeBlockCompiler) {
        this.decoder = decoder;
        this.compiler = codeBlockCompiler;
        this.bufferBytes = new byte[100];
        this.bufferOffset = 0;
        this.realModeTree = new ObjectTreeStateMachine();
        this.protectedModeTree = new ObjectTreeStateMachine();
        this.addedRealModeBlockCount = 0;
        this.foundRealModeBlockCount = 0;
        this.addedProtectedModeBlockCount = 0;
        this.foundProtectedModeBlockCount = 0;
    }

    public byte getByte() {
        if (this.replayIndex < this.bufferOffset) {
            return this.bufferBytes[this.replayIndex++];
        }
        byte by = this.source.getByte();
        this.codeBlockTree.stepTree(by);
        return by;
    }

    public CodeBlock getCodeBlock(ObjectTreeStateMachine objectTreeStateMachine) {
        this.bufferOffset = 0;
        boolean bl = true;
        while (bl) {
            byte by = this.source.getByte();
            bl = objectTreeStateMachine.stepTree(by);
            CodeBlock codeBlock = (CodeBlock)objectTreeStateMachine.getObjectAtState();
            if (codeBlock != null) {
                return codeBlock;
            }
            try {
                this.bufferBytes[this.bufferOffset] = by;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                byte[] byArray = new byte[this.bufferBytes.length * 2];
                System.arraycopy(this.bufferBytes, 0, byArray, 0, this.bufferBytes.length);
                this.bufferBytes = byArray;
                this.bufferBytes[this.bufferOffset] = by;
            }
            ++this.bufferOffset;
        }
        return null;
    }

    public RealModeCodeBlock getRealModeCodeBlock(ByteSource byteSource) {
        this.source = byteSource;
        this.realModeTree.resetTreeState();
        CodeBlock codeBlock = this.getCodeBlock(this.realModeTree);
        if (codeBlock == null) {
            this.replayIndex = 0;
            this.codeBlockTree = this.realModeTree;
            codeBlock = this.compiler.getRealModeCodeBlock(this.decoder.decodeReal(this));
            if (this.bufferOffset > 0) {
                this.realModeTree.setObjectAtState(codeBlock);
                ++this.addedRealModeBlockCount;
            }
        } else {
            ++this.foundRealModeBlockCount;
        }
        return (RealModeCodeBlock)codeBlock;
    }

    public ProtectedModeCodeBlock getProtectedModeCodeBlock(ByteSource byteSource, boolean bl) {
        this.source = byteSource;
        this.protectedModeTree.resetTreeState();
        CodeBlock codeBlock = this.getCodeBlock(this.protectedModeTree);
        if (codeBlock == null) {
            this.replayIndex = 0;
            this.codeBlockTree = this.protectedModeTree;
            codeBlock = this.compiler.getProtectedModeCodeBlock(this.decoder.decodeProtected(this, bl));
            if (this.bufferOffset > 0) {
                this.protectedModeTree.setObjectAtState(codeBlock);
                ++this.addedProtectedModeBlockCount;
            }
        } else {
            ++this.foundProtectedModeBlockCount;
        }
        return (ProtectedModeCodeBlock)codeBlock;
    }

    public ObjectTreeStateMachine getObjectTree() {
        return this.realModeTree;
    }

    public long getAddedCount() {
        return this.addedRealModeBlockCount;
    }

    public long getFoundCount() {
        return this.foundRealModeBlockCount;
    }

    public boolean skip(int n) {
        throw new IllegalStateException("Skip not implemented on " + this.getClass());
    }

    public boolean rewind(int n) {
        throw new IllegalStateException("rewind not implemented on " + this.getClass());
    }

    public boolean reset() {
        throw new IllegalStateException("reset not implemented on " + this.getClass());
    }
}

