/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator;

import java.io.IOException;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.memory.LazyMemory;
import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.memory.MemoryManager;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.memory.codeblock.CodeBlock;
import org.jpc.emulator.memory.codeblock.CodeBlockReplacementException;
import org.jpc.emulator.memory.codeblock.ObjectTreeCache;
import org.jpc.emulator.motherboard.DMAController;
import org.jpc.emulator.motherboard.GateA20Handler;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.motherboard.IntervalTimer;
import org.jpc.emulator.motherboard.RTC;
import org.jpc.emulator.motherboard.SystemBIOS;
import org.jpc.emulator.motherboard.VGABIOS;
import org.jpc.emulator.pci.PCIBus;
import org.jpc.emulator.pci.PCIHostBridge;
import org.jpc.emulator.pci.PCIISABridge;
import org.jpc.emulator.pci.peripheral.EthernetCard;
import org.jpc.emulator.pci.peripheral.PIIX3IDEInterface;
import org.jpc.emulator.pci.peripheral.VGACard;
import org.jpc.emulator.peripheral.FloppyController;
import org.jpc.emulator.peripheral.Keyboard;
import org.jpc.emulator.peripheral.PCSpeaker;
import org.jpc.emulator.peripheral.SerialPort;
import org.jpc.emulator.processor.ModeSwitchException;
import org.jpc.emulator.processor.Processor;
import org.jpc.emulator.processor.ProcessorException;
import org.jpc.support.BlockDevice;
import org.jpc.support.Clock;
import org.jpc.support.DriveSet;

public class PC {
    private Processor processor;
    private IOPortHandler ioportHandler;
    private InterruptController irqController;
    private PhysicalAddressSpace physicalAddr;
    private LinearAddressSpace linearAddr;
    private IntervalTimer pit;
    private RTC rtc;
    private DMAController primaryDMA;
    private DMAController secondaryDMA;
    private GateA20Handler gateA20;
    private PCIHostBridge pciHostBridge;
    private PCIISABridge pciISABridge;
    private PCIBus pciBus;
    private PIIX3IDEInterface ideInterface;
    private EthernetCard networkCard;
    private VGACard graphicsCard;
    private SerialPort serialDevice0;
    private Keyboard kbdDevice;
    private PCSpeaker speaker;
    private FloppyController fdc;
    private Clock vmClock;
    private DriveSet drives;
    private VGABIOS vgaBIOS;
    private SystemBIOS sysBIOS;
    private HardwareComponent[] myParts;
    private MemoryManager memoryManager;
    public static final int SYS_RAM_SIZE = 0x400000;

    public PC(Clock clock, DriveSet driveSet) throws IOException {
        this.drives = driveSet;
        this.processor = new Processor();
        this.vmClock = clock;
        this.physicalAddr = new PhysicalAddressSpace();
        for (int i = 0; i < 0x400000; i += 4096) {
            this.physicalAddr.allocateMemory(i, new LazyMemory(4096));
        }
        this.memoryManager = MemoryManager.getInstance();
        this.linearAddr = new LinearAddressSpace();
        this.ioportHandler = new IOPortHandler();
        this.irqController = new InterruptController();
        this.primaryDMA = new DMAController(false, true);
        this.secondaryDMA = new DMAController(false, false);
        this.rtc = new RTC(112, 8);
        this.pit = new IntervalTimer(64, 0);
        this.gateA20 = new GateA20Handler();
        this.ideInterface = new PIIX3IDEInterface();
        this.networkCard = new EthernetCard();
        this.graphicsCard = new VGACard();
        this.serialDevice0 = new SerialPort(0);
        this.kbdDevice = new Keyboard();
        this.fdc = new FloppyController();
        this.speaker = new PCSpeaker();
        this.pciHostBridge = new PCIHostBridge();
        this.pciISABridge = new PCIISABridge();
        this.pciBus = new PCIBus();
        this.sysBIOS = new SystemBIOS("bios.bin");
        this.vgaBIOS = new VGABIOS("vgabios.bin");
        this.myParts = new HardwareComponent[]{this.processor, this.vmClock, this.physicalAddr, this.linearAddr, this.ioportHandler, this.irqController, this.primaryDMA, this.secondaryDMA, this.rtc, this.pit, this.gateA20, this.pciHostBridge, this.pciISABridge, this.pciBus, this.ideInterface, driveSet, this.networkCard, this.graphicsCard, this.serialDevice0, this.kbdDevice, this.fdc, this.speaker, this.sysBIOS, this.vgaBIOS, this.memoryManager};
        if (!this.configure()) {
            throw new IllegalStateException("PC Configuration failed");
        }
    }

    public ObjectTreeCache getObjectTreeCache() {
        return MemoryManager.getInstance().getObjectTreeCache();
    }

    public DriveSet getDrives() {
        return this.drives;
    }

    public BlockDevice getBootDevice() {
        return this.drives.getBootDevice();
    }

    public int getBootType() {
        return this.drives.getBootType();
    }

    private boolean configure() {
        int n;
        boolean bl;
        int n2 = 0;
        do {
            bl = true;
            for (n = 0; n < this.myParts.length; ++n) {
                if (this.myParts[n].initialised()) continue;
                for (int i = 0; i < this.myParts.length; ++i) {
                    this.myParts[n].acceptComponent(this.myParts[i]);
                }
                bl &= this.myParts[n].initialised();
            }
        } while (!bl && ++n2 < 100);
        if (n2 == 100) {
            for (n = 0; n < this.myParts.length; ++n) {
                System.out.println("Part " + n + " (" + this.myParts[n].getClass() + ") " + this.myParts[n].initialised());
            }
            return false;
        }
        for (n = 0; n < this.myParts.length; ++n) {
            if (!(this.myParts[n] instanceof PCIBus)) continue;
            ((PCIBus)this.myParts[n]).biosInit();
        }
        return true;
    }

    public void reset() {
        for (int i = 0; i < this.myParts.length; ++i) {
            if (this.myParts[i] == this) continue;
            this.myParts[i].reset();
        }
        this.configure();
    }

    public Keyboard getKeyboard() {
        return this.kbdDevice;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public VGACard getGraphicsCard() {
        return this.graphicsCard;
    }

    public PhysicalAddressSpace getPhysicalMemory() {
        return this.physicalAddr;
    }

    public LinearAddressSpace getLinearMemory() {
        return this.linearAddr;
    }

    public Clock getSystemClock() {
        return this.vmClock;
    }

    public static PC createPC(String[] stringArray, Clock clock) throws IOException {
        DriveSet driveSet = DriveSet.buildFromArgs(stringArray);
        return new PC(clock, driveSet);
    }

    private final int executeRealModeStep(int n) {
        this.vmClock.process();
        this.primaryDMA.runTransfers();
        this.secondaryDMA.runTransfers();
        int n2 = 0;
        while (n > 0) {
            try {
                int n3 = this.processor.getInstructionPointer();
                CodeBlock codeBlock = this.physicalAddr.getRealModeCodeBlockAt(n3);
                try {
                    try {
                        n2 += codeBlock.execute(this.processor);
                    }
                    catch (NullPointerException nullPointerException) {
                        codeBlock = this.memoryManager.getRealModeCodeBlockAt(this.physicalAddr.getReadMemoryBlockAt(n3), n3);
                        n2 += codeBlock.execute(this.processor);
                    }
                }
                catch (CodeBlockReplacementException codeBlockReplacementException) {
                    codeBlock = this.memoryManager.handleCodeBlockReplacement(n3, codeBlockReplacementException);
                    n2 += codeBlock.execute(this.processor);
                }
                this.processor.processRealModeInterrupts();
            }
            catch (ProcessorException processorException) {
                this.processor.handleRealModeException(processorException.getVector());
            }
            --n;
        }
        return n2;
    }

    public final CodeBlock decodeBlockAt(int n) {
        if ((this.processor.getCR0() & 1) == 0) {
            return this.physicalAddr.getRealModeCodeBlockAt(n);
        }
        return this.linearAddr.getProtectedModeCodeBlockAt(n);
    }

    private final int executeProtectedModeStep(int n) {
        this.vmClock.process();
        this.primaryDMA.runTransfers();
        this.secondaryDMA.runTransfers();
        int n2 = 0;
        while (n > 0) {
            try {
                int n3 = this.processor.getInstructionPointer();
                CodeBlock codeBlock = this.linearAddr.getProtectedModeCodeBlockAt(n3);
                try {
                    try {
                        n2 += codeBlock.execute(this.processor);
                    }
                    catch (NullPointerException nullPointerException) {
                        codeBlock = this.memoryManager.getProtectedModeCodeBlockAt(this.linearAddr.getReadMemoryBlockAt(n3), n3);
                        n2 += codeBlock.execute(this.processor);
                    }
                }
                catch (CodeBlockReplacementException codeBlockReplacementException) {
                    codeBlock = this.memoryManager.handleCodeBlockReplacement(n3, codeBlockReplacementException);
                    n2 += codeBlock.execute(this.processor);
                }
                this.processor.processProtectedModeInterrupts();
            }
            catch (ProcessorException processorException) {
                this.processor.handleProtectedModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
            }
            --n;
        }
        return n2;
    }

    public final int executeRealMode() {
        int n = 0;
        int n2 = 10;
        n += this.executeRealModeStep(n2);
        n += this.executeRealModeStep(n2);
        n += this.executeRealModeStep(n2);
        n += this.executeRealModeStep(n2);
        n += this.executeRealModeStep(n2);
        n += this.executeRealModeStep(n2);
        n += this.executeRealModeStep(n2);
        n += this.executeRealModeStep(n2);
        n += this.executeRealModeStep(n2);
        return n += this.executeRealModeStep(n2);
    }

    public final int executeProtectedMode() {
        int n = 0;
        int n2 = 10;
        n += this.executeProtectedModeStep(n2);
        n += this.executeProtectedModeStep(n2);
        n += this.executeProtectedModeStep(n2);
        n += this.executeProtectedModeStep(n2);
        n += this.executeProtectedModeStep(n2);
        n += this.executeProtectedModeStep(n2);
        n += this.executeProtectedModeStep(n2);
        n += this.executeProtectedModeStep(n2);
        n += this.executeProtectedModeStep(n2);
        return n += this.executeProtectedModeStep(n2);
    }

    public final int executeStep() {
        try {
            if ((this.processor.getCR0() & 1) == 0) {
                return this.executeRealModeStep(1);
            }
            return this.executeProtectedModeStep(1);
        }
        catch (ModeSwitchException modeSwitchException) {
            return 1;
        }
    }
}

